<?php

/* --------------------------------------------------------------
   ContentLinkAttributesInterface.inc.php 2019-04-15
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Interface ContentLinkAttributesInterface
 *
 * @category   System
 * @package    Content
 * @subpackage Interfaces
 */
interface ContentLinkAttributesInterface
{
    /**
     * Return the localized content links
     *
     * @return ContentLinkCollection
     */
    public function links(): ?ContentLinkCollection;
    
    
    /**
     * Return whether the content is opened in a new tab
     *
     * @return bool
     */
    public function isOpeningInNewTab(): ?bool;
}